@rem Here is what each file in the test directory is:

@rem Original - The original test file for the JFP implementation.
@rem Modified 1 - The first copy of "Original" that has been modified.
@rem Modified 2 - The second copy of "Original" that has been modified.
@rem Patch 1 - The patch that applies the changes made to "Original" to create "Modified 1".
@rem Patch 2 - The patch that applies the changes made to "Original" to create "Modified 2".
@rem Patched 1 - The file resulting from applying "Patch 1" to "Original".
@rem 	Should match "Modified 1".
@rem Patched 2 - The file resulting from applying "Patch 2" to "Original".
@rem 	Should match "Modified 2".
@rem Patched 12 - The file resulting from applying "Patch 2" to "Patched 1".
@rem 	Should match "Patched 21".
@rem Patched 21 - The file resulting from applying "Patch 1" to "Patched 2".
@rem 	Should match "Patched 12".
@rem Undo 1 - The file resulting from applying "Patch 1" to "Patched 12".
@rem 	Assuming "Modified 2" to have "n" bytes, the first "n" bytes of "Undo 1" should match "Modified 2" and any other bytes should be 0x00 bytes.
@rem Undo 2 - The file resulting from applying "Patch 2" to "Patched 21".
@rem	Assuming "Modified 1" to have "n" bytes, the first "n" bytes of "Undo 2" should match "Modified 1" and any other bytes should be 0x00 bytes.
@rem Undo 12 - The file resulting from applying "Patch 2" to "Undo 1".
@rem 	Assuming "Original" to have "n" bytes, the first "n" bytes of "Undo 12" should match "Original" and any other bytes should be 0x00 bytes.
@rem Unpatchable - Attempting to apply "Patch 1" or "Patch 2" to this file should fail and be reported as erroneous.

SET  org="Test Suite/Original.txt"
SET mod1="Test Suite/Modified 1.txt"
SET mod2="Test Suite/Modified 2.txt"

java JFP MAKE %org% %mod1% "Test Suite/Patch 1.jfp" > NUL
java JFP MAKE %org% %mod2% "Test Suite/Patch 2.jfp" > NUL

java JFP APPLY "Test Suite/Patch 1.jfp" %org% "Test Suite/Patched 1.txt" > NUL
java JFP APPLY "Test Suite/Patch 2.jfp" %org% "Test Suite/Patched 2.txt" > NUL

java JFP APPLY "Test Suite/Patch 2.jfp" "Test Suite/Patched 1.txt" "Test Suite/Patched 12.txt" > NUL
java JFP APPLY "Test Suite/Patch 1.jfp" "Test Suite/Patched 2.txt" "Test Suite/Patched 21.txt" > NUL

java JFP APPLY "Test Suite/Patch 1.jfp" "Test Suite/Patched 12.txt" "Test Suite/Undo 1.txt" > NUL
java JFP APPLY "Test Suite/Patch 2.jfp" "Test Suite/Patched 21.txt" "Test Suite/Undo 2.txt" > NUL
java JFP APPLY "Test Suite/Patch 2.jfp" "Test Suite/Undo 1.txt" "Test Suite/Undo 12.txt" > NUL

java JFP APPLY "Test Suite/Patch 1.jfp" "Test Suite/Unpatchable.txt" > NUL
java JFP APPLY "Test Suite/Patch 2.jfp" "Test Suite/Unpatchable.txt" > NUL

pause
